/******************************************************************************
 * \file: trace_UsrCfg.h
 *
 * \version: $Id: trace_UsrCfg.h,v 1.6 2011/03/29 11:37:09 ddevarasu Exp $
 *
 * This file has been reused from Gen1 Trace as-it-is for backward compatability.
 *
 * \component: Gen2 Trace
 *
 * \author Sakthivelu.S
 *
 * \copyright: (c) 2003 - 2009 ADIT
 *
 *****************************************************************************/
#ifndef _TRACE_USRCFG_H
#define _TRACE_USRCFG_H

/*---------------------------------------------------------------------------*/
/* DON'T MODIFY THIS SERVER COPY. Please update your local copy and build    */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/*  Header file for Trace class definitions goes here                        */
/*  Applications can include their class definition files                    */
/*---------------------------------------------------------------------------*/
//include <filename>
#ifdef EARLY_TRACE_CAL
#include "cal_trace.h"
#endif

#ifdef EARLY_TRACE_SYSTEM_MANAGER
#include "sys_trace_ttfis.h"
#endif

#ifdef EARLY_TRACE_DRIVER_MANAGER
#include "drvmgr_trace_ttfis.h"
#endif


/* Count of classes to be enabled */
 
#define COUNT_TR_BASIC                          (1)

#ifdef EARLY_TRACE_CAL
  #define COUNT_TR_CLASSES_CAL                  (5)
#else
  #define COUNT_TR_CLASSES_CAL                  (0)
#endif

#ifdef EARLY_TRACE_SYSTEM_MANAGER
  #define COUNT_TR_CLASSES_SYSTEM_MANAGER       (27)
#else
  #define COUNT_TR_CLASSES_SYSTEM_MANAGER       (0)
#endif

#ifdef EARLY_TRACE_DRIVER_MANAGER
  #define COUNT_TR_CLASSES_DRVIVER_Manager      (3)
#else
  #define COUNT_TR_CLASSES_DRVIVER_Manager      (0)
#endif


#define TR_COUNT_CLASSES_FROM_USER   (COUNT_TR_BASIC + \
                                      COUNT_TR_CLASSES_CAL + \
                                      COUNT_TR_CLASSES_SYSTEM_MANAGER + \
                                      COUNT_TR_CLASSES_DRVIVER_Manager)

/* the default level for the classes from the file,
 * should be  one of the value define in adit_trace.h
 */
#define TR_LEVEL_FOR_CLASSES_FROM_USER  TR_LEVEL_USER_4

/* the classes to be enabled at start up */
LOCAL  U16  trClassFromUser[TR_COUNT_CLASSES_FROM_USER] = {
#ifdef EARLY_TRACE_CAL
  CAL_TR_CLASS_MESSAGES,
  CAL_TR_CLASS_ENTER_FUNCTION,
  CAL_TR_CLASS_EXIT_FUNCTION,
  CAL_TR_CLASS_DEBUG,
  CAL_TR_CLASS_CHECKPOINTS,
#endif /* EARLY_TARCE_CAL */

#ifdef EARLY_TRACE_SYSTEM_MANAGER
  TR_CLASS_SYSTEM_MANAGER_MAIN_QUIET,
  TR_CLASS_SYSTEM_MANAGER_MAIN_NORMAL,
  TR_CLASS_SYSTEM_MANAGER_MAIN_VERBOSE,

  /* traceclasses for system statemachine */
  TR_CLASS_SYSTEM_MANAGER_SYSTEM_STATE_QUIET,
  TR_CLASS_SYSTEM_MANAGER_SYSTEM_STATE_NORMAL,
  TR_CLASS_SYSTEM_MANAGER_SYSTEM_STATE_VERBOSE,

  /* traceclasses for messagemapper */
  TR_CLASS_SYSTEM_MANAGER_MSG_MAPPER_QUIET,
  TR_CLASS_SYSTEM_MANAGER_MSG_MAPPER_NORMAL,
  TR_CLASS_SYSTEM_MANAGER_MSG_MAPPER_VERBOSE,

  /* traceclasses for cal_reader */
  TR_CLASS_SYSTEM_MANAGER_CAL_READER_QUIET,
  TR_CLASS_SYSTEM_MANAGER_CAL_READER_NORMAL,
  TR_CLASS_SYSTEM_MANAGER_CAL_READER_VERBOSE,

  /* traceclasses for calfifo */
  TR_CLASS_SYSTEM_MANAGER_CAL_FIFO_QUIET,
  TR_CLASS_SYSTEM_MANAGER_CAL_FIFO_NORMAL,
  TR_CLASS_SYSTEM_MANAGER_CAL_FIFO_VERBOSE,

  /* traceclasses for voltage supervision */
  TR_CLASS_SYSTEM_MANAGER_VOLT_SUPERVISION_QUIET,
  TR_CLASS_SYSTEM_MANAGER_VOLT_SUPERVISION_NORMAL,
  TR_CLASS_SYSTEM_MANAGER_VOLT_SUPERVISION_VERBOSE,

  /* traceclasses for temperature supervision */
  TR_CLASS_SYSTEM_MANAGER_TEMP_SUPERVISION_QUIET,
  TR_CLASS_SYSTEM_MANAGER_TEMP_SUPERVISION_NORMAL,
  TR_CLASS_SYSTEM_MANAGER_TEMP_SUPERVISION_VERBOSE,

  /* traceclass for system manager core */
  TR_CLASS_SYSTEM_MANAGER_CORE_QUIET,
  TR_CLASS_SYSTEM_MANAGER_CORE_NORMAL,
  TR_CLASS_SYSTEM_MANAGER_CORE_VERBOSE,

  /* traceclass for system manager slave on tiger */
  TR_CLASS_SYSTEM_MANAGER_SLAVE_QUIET,
  TR_CLASS_SYSTEM_MANAGER_SLAVE_NORMAL,
  TR_CLASS_SYSTEM_MANAGER_SLAVE_VERBOSE,
#endif /* EARLY_TRACE_SYSTEM_MANAGER */

#ifdef EARLY_TRACE_DRIVER_MANAGER
  TR_CLASS_DRVMGR_MAIN_QUIET,
  TR_CLASS_DRVMGR_MAIN_NORMAL,
  TR_CLASS_DRVMGR_MAIN_VERBOSE,
#endif /* EARLY_TRACE_DRIVER_MANAGER */

  TR_CLASS_TRACE
};     

#endif /* _TRACE_USRCFG_H */



